// copyright 2000 Eric Gunnerson
using System;
using System.IO;

public class DirectoryWalker
{
    public delegate void ProcessDirCallback(Directory dir, int level, object obj);
    public delegate void ProcessFileCallback(File file, int level, object obj);
    
    public DirectoryWalker(    ProcessDirCallback dirCallback,
    ProcessFileCallback fileCallback)
    {
        this.dirCallback = dirCallback;
        this.fileCallback = fileCallback;
    }
    
    public void Walk(string rootDir, object obj)
    {
        DoWalk(new Directory(rootDir), 0, obj);
    }
    void DoWalk(Directory dir, int level, object obj)
    {
        foreach (FileSystemEntry d in dir.GetFileSystemEntries ()) 
        {
            if (d is File)
            {
                if (fileCallback != null)
                fileCallback((File) d, level, obj);
            }
            else
            {
                if (dirCallback != null)
                dirCallback((Directory) d, level, obj);
                DoWalk((Directory) d, level + 1, obj);
            }
        }
    }
    
    ProcessDirCallback    dirCallback;
    ProcessFileCallback    fileCallback;
}

class Test
{
    public static void PrintDir(Directory d, int level, object obj)
    {
        WriteSpaces(level * 2);
        Console.WriteLine("Dir: {0}", d.FullName);
    }
    public static void PrintFile(File f, int level, object obj)
    {
        WriteSpaces(level * 2);
        Console.WriteLine("File: {0}", f.FullName);
    }
    public static void WriteSpaces(int spaces)
    {
        for (int i = 0; i < spaces; i++)
        Console.Write(" ");
        
    }
    public static void Main(string[] args)
    {
        DirectoryWalker dw = new DirectoryWalker(
        new DirectoryWalker.ProcessDirCallback(PrintDir),
        new DirectoryWalker.ProcessFileCallback(PrintFile));
        
        string root = ".";
        if (args.Length == 1)
        root = args[0];
        dw.Walk(root, "Passed string object");
    }
}